<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Category;
use Illuminate\Http\Request;

class SearchController extends Controller
{
    //

    public function index(Request $request){
        $this->validate($request, [
            "q" => "required"
        ]);

        $products = Product::where('name', 'LIKE', '%'.$request->q.'%')
                            ->orWhere('description', 'LIKE', '%'.$request->q.'%')->paginate(1);
        return view("search")->with(["products" => $products]);
    }
}
