@extends("layouts.admin")
@section("title", "Payments")
@section('content')

<div class="container-fluid">
    <!-- Page-Title -->
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <div class="row">
                    <div class="col">
                        <h4 class="page-title">Payments</h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Landnkitchen</a></li>
                            <li class="breadcrumb-item active">Payments</li>
                        </ol>
                    </div><!--end col-->
                </div><!--end row-->
            </div><!--end page-title-box-->
        </div><!--end col-->
    </div><!--end row-->
    <!-- end page title end breadcrumb -->
    <div class="row">
        <div class="col-12">
            @if (Session::has('error'))
                <div class="alert alert-danger" role="alert">
                    {{ Session::get('error') }}
                </div>
            @endif
            @if (Session::has('success'))
                <div class="alert alert-success" role="alert">
                    {{ Session::get('success') }}
                </div>
            @endif
            <div class="table-responsive">
                <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                    <tr>
                        <th>SN</th>
                        <th>OrderId</th>
                        <th>Reference</th>
                        <th>Name</th>
                        <th>Price</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                    </thead>
                    <tbody>
                        @php $sn = 1 @endphp
                        @foreach ( $payments as $row )

                        <tr>
                            <td>{{ $sn }}</td>
                            <td>{{ $row->order_id }}</td>
                            <td>{{ $row->reference }}</td>
                            <td>{{ $row->fullname }}</td>
                            <td>&#8358; {{ number_format($row->amount, 2) }}</td>
                            <td>{{ $row->status }}</td>
                            <td>{{ $row->created_at->diffForHumans() }}</td>
                        </tr>
                        @php $sn ++ @endphp
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

</div><!-- container -->


@endsection
