@extends('layouts.app')
@section("title", "Cart")
@section('content')

<div id="wrapper">

    <section class="yt-bg-player yt-cart">
        <div class="bg-transparent ">
            <!-- Slider content -->
            <div class="container dark slider-content"> <i class="icon-top-draw"></i>
                <div id="text-transform" class="owl-carousel">
                    <div class="item">
                        <h1>Checkout</h1>
                    </div>
                </div>
                <p class="text-capitalize">An Oasis Of Pleasure</p>
                <i class="icon-bottom-draw"></i>
            </div>
            <!-- End Slider content -->
        </div>
        <!-- End Bg transparent -->
    </section>
    @include('layouts.includes.main-header')

  <div id="content">
    @include('layouts.includes.main-nav')
        <!-- My Account
    ============================================= -->
    <section class="myaccount text-left padding-100">
        <div class="container">
            <div class="row">
                <div class="col-md-12 carts-content">
                    <div class="row">
                        <!-- Cart Total -->
                        <div class="col-md-4 carts-total text-left">
                            @php
                                $total = 0;
                                $subtotal = 0;
                                $vat = 0;
                            @endphp
                            @if(count($cart) != 0)
                                @foreach($cart as $row)
                                    @php
                                        $total += floatval($row['price']) * intval($row['quantity']);
                                        $subtotal += floatval($row['price']) * intval($row['quantity']);
                                        $vat += floatval($row['vat']);
                                    @endphp
                                @endforeach
                            @endif
                            @if(session()->has('deliverycost') && session('type')=='delivery')
                                @php $total += session('deliverycost'); @endphp
                            @endif

                            @if(session('takeaway_fee') && session('type')!='dine_in' && session()->has('type'))
                                @php $total += session('takeaway_fee'); @endphp
                            @endif

                        <h3>Carts Total</h3>
                        <table class="table table-bordered">
                            <tbody>
                            <tr>
                                <td>Cart Subtotal</td>
                            <td>₦ {{number_format($subtotal,2)}}</td>
                            </tr>
                            <tr>
                                <td>Delivery Charges</td>
                                <td>@if(session('deliverycost') && session('type')=='delivery') ₦ {{number_format(session('deliverycost'),2)}} @else N/A @endif</td>
                            </tr>
                            @if(session('takeaway_fee') && session('type')!='dine_in' && session()->has('type'))
                            <tr>
                                <td>Takeaway Pack Charges</td>
                                <td>
                                    ₦ {{number_format(session('takeaway_fee'),2)}}
                                <span class="pull-right"> x{{session('takeaway_count')}}</span>
                                </td>
                            </tr>
                            @endif
                            <tr>
                                <td>V.A.T (7.5 %)</td>
                                    <td>₦ {{number_format($vat,2)}}</td>
                                </tr>
                            <tr>
                                <td>Order Total</td>
                                    @php
                                        session()->put('vat', $vat);
                                        $total += $vat;
                                    @endphp
                                    <td>₦ {{number_format($total,2)}}</td>
                                </tr>
                            </tbody>
                        </table>

                        <div class="calc-shipping margin-tb-60">
                            @if(!session('type'))
                                <h3>Select Option</h3>
                            @else
                                <h3>Update Option</h3>
                            @endif
                            <div class="form-group">
                            <div class="select_wrap">
                                <select id="type" class="form-control" name="location" required>
                                    <option value="">-- SELECT --</option>
                                    <option value="dine_in">DINE IN</option>
                                    <option value="pick_up">PICK UP</option>
                                    <option value="delivery">DELIVERY</option>
                                </select>
                            </div>
                            </div>
                        </form>
                        </div>

                            <div id="delivery" class="calc-shipping margin-tb-60">
                                <h3>Delivery</h3>
                                <form action="{{route('del.checkout')}}" method="POST">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Delivery Date</label>
                                                <input type="date" name="delivery_date" id="delivery_date" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->

                                        <div class="col-lg-6">
                                            <div class="input-group">
                                            <label>Delivery Time</label>
                                            <input type="time" name="delivery_time" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->

                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <input class="form-control" type="hidden" name="type" value="delivery" />
                                                <div class="select_wrap">
                                                    <select class="form-control" name="location" required>
                                                        <option value="one">Select Your Location</option>
                                                        @foreach($locations as $loc)
                                                            <option value="{{$loc->id}}">{{$loc->location}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- End select wrap -->

                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="address" placeholder="Address" size="50" required value="@if(Auth::check()) {{ auth()->user()->address }} @endif">
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <label>Instructions</label>
                                                <textarea name="instructions" class="form-control" cols="35" rows="5"></textarea>
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->

                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <br>
                                                <button type="submit" class="btn form-control btn-black">UPDATE</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- Carts total -->

                            <div id="dine_in" class="calc-shipping margin-tb-60">
                                <h3>Dine In</h3>
                                <form action="{{route('del.checkout')}}" method="POST">
                                    @csrf
                                    <input type="hidden" name="type" value="dine_in" />
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Arrival Date</label>
                                                <input type="date" name="arrival_date" id="arrival_date" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Arrival Time</label>
                                                <input type="time" name="arrival_time" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <label>Instructions</label>
                                                <textarea name="instructions" class="form-control" cols="35" rows="5"></textarea>
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-12">
                                            <br>
                                            <button type="submit" class="btn form-control btn-black">Submit</button>
                                        </div>
                                    </div><!-- /.row -->
                                </form>
                            </div>

                            <div id="pick_up" class="calc-shipping margin-tb-60">
                                <h3>Pick Up</h3>
                                <p>Note:<i> Extra Fee of N250 for takeaway pack applies for each item</i></p>
                                <form action="{{route('del.checkout')}}" method="POST">
                                    @csrf
                                    <input type="hidden" name="type" value="pick_up" />
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Pickup Date</label>
                                                <input type="date" name="pickup_date" id="pickup_date" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-6">
                                            <div class="input-group">
                                                <label>Pickup Time</label>
                                                <input type="time" name="pickup_time" class="form-control" aria-label="...">
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-12">
                                            <div class="input-group">
                                                <label>Instructions</label>
                                                <textarea name="instructions" class="form-control" cols="35" rows="5"></textarea>
                                            </div><!-- /input-group -->
                                        </div><!-- /.col-lg-6 -->
                                        <div class="col-lg-12">
                                            <br>
                                            <button type="submit" class="btn form-control btn-black">Submit</button>
                                        </div>
                                    </div><!-- /.row -->
                                </form>
                            </div>
                        </div>
                        <!-- End # Cart Total -->

                        <!-- Billing Details -->
                        <div class="col-md-8">
                            <div class="calc-shipping">
                                <h3>Customer Details @guest<small>Already have an account? <a href="{{route('login')}}" class="btn-link">Login</a></small>@endguest</h3>
                                @if(!Auth::check())
                                    <form action="{{route('guest-user.store')}}" method="POST">
                                        @csrf
                                        <div class="form-group">
                                            <input type="text" class="form-control @error('first_name') border border-danger @enderror " name="first_name" placeholder="First Name*">
                                            @error('first_name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                        </div>
                                        <div class="form-group">
                                            <input type="text" class="form-control  @error('last_name') border border-danger @enderror" name="last_name" placeholder="Last Name*">
                                            @error('last_name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                        </div>
                                        <div class="form-group">
                                            <input type="text" class="form-control @error('address') border border-danger @enderror " name="address" placeholder="Address*">
                                            @error('address')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                        </div>
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="email" placeholder="Email">
                                            @error('email')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                        </div>
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="phone" placeholder="Phone">
                                            @error('phone')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                        </div>

                                        @if(session('type'))
                                            <button type="submit" class="btn form-control btn-black">Order Now</button>
                                        @else
                                            <button type="button" class="btn form-control btn-black" disabled>please select option before proceeding</button>
                                        @endif
                                    </form>
                                @else
                                    <div class="form-group">
                                        <input type="text" class="form-control" value="{{auth()->user()->first_name.' '.auth()->user()->last_name}}" readonly>
                                        <input type="text" class="form-control" value="{{auth()->user()->email}}" readonly>
                                        <input type="text" class="form-control" value="{{auth()->user()->tel}}" readonly>
                                        <input type="text" class="form-control" value="{{auth()->user()->address}}" readonly>
                                    </div>
                                    @if(session('type'))
                                        <a href="{{route('payment')}}" class="btn form-control btn-black">Order Now</a>
                                    @else
                                        <button type="button" class="btn form-control btn-black" disabled>please select option before proceeding</button>
                                    @endif
                                @endif
                            </div>
                        </div>
                        <!-- Billing Details -->
                    </div>
                </div>
            </div>
        </div>
    </section>
      <!-- End myaccount -->
  </div>
  <!-- end of #content -->
</div>

<script src="javascripts/libs/jquery.min.js" type="text/javascript"></script>
<script>

    $("#pick_up").hide();
    $("#dine_in").hide();
    $("#delivery").hide();

    $("#type").change(function() {
        if( $("#type").val() == "pick_up"){
            $("#pick_up").show();
            $("#dine_in").hide();
            $("#delivery").hide();
        }else if($("#type").val() == "dine_in"){
            $("#dine_in").show();
            $("#pick_up").hide();
            $("#delivery").hide();
        }else if($("#type").val() == "delivery"){
            $("#delivery").show();
            $("#pick_up").hide();
            $("#dine_in").hide();
        }else{
            $("#pick_up").hide();
            $("#dine_in").hide();
            $("#delivery").hide();
        }
    });
  $('#delivery_date, #arrival_date, #pick_date').attr('min', new Date().toISOString().split('T')[0])

</script>
@endsection
