@extends('layouts.app')
@section("title", "Payments")
@section('content')

<div id="wrapper">

    <section class="yt-bg-player yt-cart" >
        <div class="bg-transparent ">
            <!-- Slider content -->
            <div class="container dark slider-content"> <i class="icon-top-draw"></i>
                <div id="text-transform" class="owl-carousel">
                <div class="item">
                    <h1>Payment</h1>
                </div>
                </div>
                <p class="text-capitalize">An Oasis Of Pleasure</p>
                <i class="icon-bottom-draw"></i>
            </div>
            <!-- End Slider content -->
        </div>
        <!-- End Bg transparent -->
    </section>
    @include('layouts.includes.main-header')

  <div id="content">
    @include('layouts.includes.main-nav')
    <!-- Carts
    ============================================= -->
    <section class="carts text-center padding-100">
        <div class="container">
          <div class="row">
            <div class="col-md-12">

            <!-- Cart Total -->
              <center>
                <div class="col-md-6 col-md-offset-3 carts-total text-left">
                    @php
                        $total = 0;
                        $paystack_charge = 0;
                    @endphp
                    @if(count($cart) != 0)
                        @foreach($cart as $row)
                            @php $total += $row['price'] * $row['quantity'];@endphp
                        @endforeach
                        @if(session()->has('deliverycost') && session('type')=='delivery')
                            @php $total += session('deliverycost'); @endphp
                        @endif
                        @if(session()->has('takeaway_fee') && session('type')!='dine_in' && session()->has('type'))
                            @php $total += session('takeaway_fee'); @endphp
                        @endif
                        @php
                            $total += session('vat');
                            if($total >= 2000){
                                $paystack_charge = $total * 0.015;
                            }
                            $total_money = $total + $paystack_charge + 100;
                            $paystack_amount = ($total_money * 100);
                        @endphp
                    @endif

                    <h3>Order Summary</h3>
                        @if(!Auth::check())
                            <table class="table table-bordered">
                                @if(session()->has('user'))
                                    @php $user = session()->get('user') @endphp
                                    <tbody>
                                        <tr>
                                            <td>Full Name</td>
                                            <td>{{$user['first_name'].' '.$user['last_name']}}</td>
                                        </tr>
                                        <tr>
                                            <td>Email Address</td>
                                            <td>{{$user['email']}}</td>
                                        </tr>
                                        <tr>
                                            <td>Phone Number</td>
                                            <td>{{$user['phone']}}</td>
                                        </tr>
                                        <tr>
                                            <td>Address</td>
                                            <td>{{$user['address']}}</td>
                                        </tr>
                                        <tr>
                                            <td>Delivery Charges</td>
                                            <td>N/A</td>
                                        </tr>
                                        <tr>
                                            <td>V.A.T (7.5%)</td>
                                            <td>₦ {{number_format(session('vat'),2)}}</td>
                                        </tr>
                                        <tr>
                                            <td>Order Total</td>
                                            <td>₦ {{number_format($total_money,2)}} (Charges Inclusive)</td>
                                        </tr>
                                    </tbody>
                                @endif
                            </table>
                            @else
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td>Full Name</td>
                                            <td>{{auth()->user()->first_name.' '.auth()->user()->last_name}}</td>
                                        </tr>
                                        <tr>
                                            <td>Email Address</td>
                                            <td>{{auth()->user()->email}}</td>
                                        </tr>
                                        <tr>
                                            <td>Phone Number</td>
                                            <td>{{auth()->user()->phone}}</td>
                                        </tr>
                                        <tr>
                                            <td>Address</td>
                                            <td>{{session('deliveryaddress')}}</td>
                                        </tr>
                                        <tr>
                                            <td>Delivery Charges</td>
                                            <td>@if(session('deliverycost')) ₦{{session('deliverycost')}} @else N/A @endif</td>
                                        </tr>
                                        <tr>
                                            <td>V.A.T (7.5%)</td>
                                            <td>₦ {{number_format(session('vat'),2)}}</td>
                                        </tr>
                                        <tr>
                                            <td>Order Total</td>
                                            <td>₦ {{number_format($total_money,2)}} (Charges Inclusive)</td>
                                        </tr>
                                    </tbody>
                                </table>
                            @endif
                            <div class="calc-shipping margin-tb-60">
                                <h3>Select Payment Method</h3>
                                <div class="form-group">
                                    <!-- Selct wrap -->
                                    <div class="select_wrap dark_slect">
                                        <select class="form-control">
                                            <option selected value="credit-card">Card Payment</option>
                                            <option value="bank_transfer" disabled>Bank Transfer</option>
                                        </select>
                                    </div>
                                    <!-- End select wrap -->
                                </div>
                            </div>
                            @if(Auth::check())
                                <form method="POST" action="{{ route('pay') }}" accept-charset="UTF-8" class="form-horizontal" role="form">
                                    <div class="row" style="margin-bottom:40px;">
                                        <div class="col-md-8 col-md-offset-2">
                                            <input type="hidden" name="email" value="{{auth()->user()->email}}"> {{-- required --}}
                                            <input type="hidden" name="amount" value="{{$paystack_amount}}">
                                            <input type="hidden" name="quantity" value="1">
                                            <input type="hidden" name="currency" value="NGN">
                                            <input type="hidden" name="metadata" value="{{ json_encode($array = ['name' => auth()->user()->getFullName(),'cart' => $cart,'user' => auth()->user(),'user_id' => auth()->user()->id]) }}" > {{-- For other necessary things you want to add to your payload. it is optional though --}}
                                            @php
                                                $ref = Paystack::genTranxRef();
                                                session()->put('ref', $ref);
                                                session()->put('paystack_amount', $paystack_amount);
                                            @endphp
                                            <input type="hidden" name="reference" value="{{ $ref }}"> {{-- required --}}
                                            @csrf
                                            <p>
                                                <button class="btn btn-black btn-lg btn-block" type="submit" value="Pay Now!">
                                                    <i class="fa fa-plus-circle fa-lg"></i> Pay Now
                                                </button>
                                            </p>
                                        </div>
                                    </div>
                                </form>
                            @else
                            @php $user = session('user'); @endphp
                                <form method="POST" action="{{ route('pay') }}" accept-charset="UTF-8" class="form-horizontal" role="form">
                                    <div class="row" style="margin-bottom:40px;">
                                        <div class="col-md-8 col-md-offset-2">
                                            <input type="hidden" name="email" value="{{$user['email']}}"> {{-- required --}}
                                            <input type="hidden" name="amount" value="{{$paystack_amount}}">
                                            <input type="hidden" name="quantity" value="1">
                                            <input type="hidden" name="currency" value="NGN">
                                            <input type="hidden" name="metadata" value="{{ json_encode($array = ['name' => $user['first_name'].' '.$user['last_name'],'cart' => $cart,'user' => $user,'user_id' => null]) }}" > {{-- For other necessary things you want to add to your payload. it is optional though --}}
                                            @php
                                                $ref = Paystack::genTranxRef();
                                                session()->put('ref', $ref);
                                                session()->put('paystack_amount', $paystack_amount);
                                            @endphp
                                            <input type="hidden" name="reference" value="{{ $ref }}"> {{-- required --}}
                                            @csrf
                                            <p>
                                                <button class="btn btn-black btn-lg btn-block" type="submit" value="Pay Now!">
                                                    <i class="fa fa-plus-circle fa-lg"></i> Pay Now
                                                </button>
                                            </p>
                                        </div>
                                    </div>
                                </form>
                            @endif
                <!-- Carts total -->
                </div>
            </center>
            <!-- End # Cart Total -->
            </div>
          </div>
        </div>
      </section>
      <!-- End Carts -->
  </div>
  <!-- end of #content -->
</div>

@endsection
