<?php
namespace App\Http\Actions;

use App\Models\Order;
use App\Models\Location;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;

class InitializeTransaction{

    private $total;
    /**
     * Completes transaction after successful paystack payment
     *
     */
    public function execute(){
        $ref = session('ref');
        $amt = session('paystack_amount');
        $amount = $amt / 100;
        $order_id = now()->format('dmYhis');
        $location = Location::find(session('location'));
        $cookie_data = stripcslashes(session("_cart"));
        $cart = json_decode($cookie_data, true);
        $type = session()->get('type');
        $date = session()->get('date');
        $time = session()->get('time');
        $instructions = session()->get('instructions');
        $takeaway = session('takeaway');
        $all_total = $this->total + session('deliverycost') + $takeaway;
        if(!Auth::check()){
            $user = session('user');
            $fullname = $user['first_name'] . ' '. $user['last_name'];
            $email = $user['email'];
            $tel = $user['phone'];
            $address = $user['address'];
            $user_id = 0;
        }else{
            $user = auth()->user();
            $fullname = $user->getFullName();
            $email = $user->email;
            $tel = $user->tel;
            $address = $user->address;
            $user_id = $user->id;
        }
        $data = [
            'user_id' => $user_id,
            'name' => $fullname,
            'email' => $email,
            'phone' => $tel,
            'address' => $address,
            'location' => $location->location ?? null,
            'cart' => $cart,
            'order_id' => $order_id,
            'cost' => session('deliverycost'),
            'date' => now(),
            'type' => $type,
            'r_date' => $date,
            'time' => $time,
            'instructions' => $instructions,
            'takeaway' => $takeaway,
            'all_total' => $all_total,
        ];
        session()->put('data', $data);
        $this->storeTransaction($ref, $order_id, $amount, $user_id, $fullname);
        $this->storeOrder($cart, $order_id, $email, $tel, $address, $user_id, $fullname);
    }

    private function storeTransaction($ref, $order_id, $amount, $user_id, $fullname)
    {
        $hasReference = Transaction::where('reference', $ref)->exists();
        if (!$hasReference) {
            $trans = Transaction::create(
                [
                    'fullname' => $fullname,
                    'order_id' => $order_id,
                    'reference' => session('ref'),
                    'status' => 'initialized',
                    'amount' => $amount,
                    'items' => session("_cart"),
                    'user_id' => $user_id,
                    'status' => "pending",
                ]);
        }
    }

    private function storeOrder($cart, $order_id, $email, $tel, $address, $user_id, $fullname)
    {
        $type = session()->get('type');
        $date = session()->get('date');
        $time = session()->get('time');
        $instructions = session()->get('instructions');

        foreach ($cart as $row) {
            $subtotal = $row['price'];
            $this->total = $subtotal * $row['quantity'];
            Order::create([
                'order_id' => $order_id,
                'user_id' => $user_id,
                'product_id' => $row['id'],
                'fullname' => $fullname,
                'email' => $email,
                'phone' => $tel,
                'address' => $address,
                'quantity' => $row['quantity'],
                'price' => $row['price'],
                'subtotal' => $subtotal,
                'total' => $this->total,
                'type' => $type,
                'date' => $date,
                'time' => $time,
                'instructions' => $instructions,
                'payment_status' => 'pending',
                'sale_status' => 'pending',
            ]);
        }
    }
}
?>
