<?php
namespace App\Http\Actions;

use App\Mail\ReceiptMail;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Mail;

class PaymentWebhook{

    public function ProcessPaymentWebhook($request): JsonResponse
    {
        $payload = $request->payload;
        if ($payload['event'] == 'charge.success') {
            $client_email = $payload['data']['metadata']['user']['email'];
            $data = $payload['data'];
            (new CompleteTransaction())->execute($data);
            //mails
            Mail::to($client_email)->send(new ReceiptMail($data));
            Mail::to('sales@landnkitchen.com')->send(New ReceiptMail($data));
            Mail::to('info@landnkitchen.com')->send(New ReceiptMail($data));
            Mail::to('landnkitchen@gmail.com')->send(New ReceiptMail($data));
        }
        return response()->json();
    }
}
?>
