<?php

namespace App\Http\Controllers;

use Exception;
use App\Models\Order;
use Illuminate\Http\Request;


class OrderController extends Controller
{
    //
    public function manage(){
        //get orders
        $orders = Order::all();
        return view("admin.sales.manage")->with(["orders" => $orders]);
    }

    public function deleteModal($id){
        $order = Order::find($id);
        $view = view('modals.order.delete', compact('order'))->render();
        return response()->json(['html'=>$view]);
    }

    public function delete(Request $request){
        try {
            Order::where("id", $request->id)->delete();
            return redirect()->back()->with("success", "Order Deleted");
        } catch (Exception $e) {
            return redirect()->back()->with("error", "Oops, there was an error!!");
        }
    }

    public function viewModal($id){
        $order = Order::find($id);
        $view = view('modals.order.view', compact('order'))->render();
        return response()->json(['html'=>$view]);
    }
}
