@extends('layouts.app')
@section("title", "Login")
@section('content')


<div id="wrapper">

            
      @include('layouts.includes.main-header')

    <!-- Content
    ============================================= -->
    <div id="content">

    @include('layouts.includes.main-nav')
            <!-- Login Default
    ============================================= -->
    <section class="padding-100 login">
        <div class="container">
          <div class="row">
            <div class="col-md-4 col-md-offset-4 col-sm-6 col-sm-offset-3">
                <div class="text-center">
                    <i class="icon-intro"></i>
                    <h1>Login</h1>
                    <span class="welcome ">Login to continue</span>
                </div>
              <div class="form-group padding-50">
                <form method="POST" action="{{ route("login") }}">
                    @csrf
                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" class="form-control @error('email') border border-danger @enderror" name="email">
                        @error('email')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" name="password" class="form-control @error('password') border border-danger @enderror">
                        @error('password')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                    </div>
                  <button type="submit" class="btn form-control btn-black">Login</button>
                </form>
              </div>
              <div class="forget text-center">
                <p><a href="{{ route("register") }}">Create an account <i class="fa fa-chevron-circle-right"></i></a></p>
                <p><a href="">I've forgotten my password <i class="fa fa-chevron-circle-right"></i></a></p>
              </div>
            </div>
          </div>
        </div>
      </section>
      <!-- End Login Default -->
    </div>
    <!-- end of #content -->
</div>
@endsection
