@extends('layouts.app')
@section("title", "Contact")
@section('content')

 <script src="https://www.google.com/recaptcha/api.js"></script>
<div id="wrapper">

    
    @include('layouts.includes.main-header')

  <div id="content">
    @include('layouts.includes.main-nav')
    <!-- Our Contact
    ============================================= -->
    <section class="contact text-center padding-100">
      <div class="container">
        <div class="row">
          <!-- Head Title -->
            <div class="head_title">
                <i class="icon-intro"></i>
                <h1>Send Message</h1>
                <span class="welcome">Keep in Touch</span>
            </div>
            <!-- End# Head Title -->
          <!-- Contact form -->
          <div class="contact-form">
            @if (Session::has('error'))
                <div class="alert alert-danger">{{ Session::get('error') }}</div>
            @endif
            @if (Session::has('success'))
                <div class="alert alert-success">{{ Session::get('success') }}</div>
            @endif
            <form method="post" action="{{ route("contact") }}" class="form" id="contact-form">
              <!-- Form Group -->

              @csrf
              <div class="form-group">
                <div class="row">
                  <div class="col-md-6 col-sm-6 col-sx-12">
                    <!-- Element -->
                    <div class="element">
                      <input type="text" name="name" class="form-control text" value="{{ old("name") }}" placeholder="Name *" required/>
                      @error('name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                    </div>
                    <!-- End Element -->
                  </div>
                  <div class="col-md-6 col-sm-6 col-sx-12">
                    <!-- Element -->
                    <div class="element">
                      <input type="text" name="email" class="form-control text" value="{{ old('email') }}" placeholder="E-mail *" required/>
                      @error('email')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                    </div>
                    <!-- End Element -->
                  </div>

                </div>
              </div>
              <!-- End form group -->

              <div class="form-group">
                <div class="row">
                  <div class="col-md-12 col-sm-6 col-sx-12">
                    <!-- Element -->
                    <div class="element">
                      <input type="text" name="subject" class="form-control text" value="{{ old("subject") }}" placeholder="Subject *" required/>
                      @error('subject')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                    </div>
                    <!-- End Element -->
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-md-12">
                  <!-- Form Group -->
                  <div class="form-group">
                    <!-- Element -->
                    <div class="element">
                      <div>
                        <!-- Element -->
                        <div class="element">
                          <textarea name="message" class="text textarea" placeholder="Message *" required>{{ old('message') }}</textarea>
                          @error('message')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                        </div>
                        <!-- End Element -->
                      </div>
                    </div>
                    <!-- End Element -->
                  </div>
                  <!-- End form Group -->
                </div>
              </div>
              <!-- Element -->
              <div class="element">
                  <br/>
                <div class="g-recaptcha" data-sitekey="6LdbA-8nAAAAAO0lqQsI4eMJVflYwo0hp9XPXcXF"></div>
                <button type="submit" id="submit"  class="btn btn-black"
                >Send</button>
              </div>
              <!-- End Element -->
            </form>

          </div>
          <!-- End contact form -->
        </div>
      </div>
    </section>
    <!-- End contact -->
    <!-- Address content
    ============================================= -->
    <section class="address-content dark">
      <!--  BG parallax -->
      <div id="address-content">
        <div class="bcg"
                data-center="background-position: 50% 0px;"
                data-bottom-top="background-position: 50% 100px;"
                data-top-bottom="background-position: 50% -100px;"
                data-anchor-target="#address-content"
                style="background-image:url('img/cafe.jpg');"
              >
          <!-- BG transparent -->
          <div class="bg-transparent padding-100">
            <div class="container">
              <div class="row">
                <!-- Adress -->
                <div class="col-md-4 adress">
                  <!-- Icon -->
                  <div class="col-md-3 icon "> <i class="fa fa-road"></i> </div>
                  <!-- End Icon -->
                  <!-- Content Item -->
                  <div class="col-md-9 content-item">
                    <h3>Address</h3>
                    <p> KM 25 Airport Road, ASO Lugbe.</p>
                  </div>
                  <!-- End content Item -->
                </div>
                <!--End Adress -->
               <div class="col-md-4 email">
                  <!-- Icon -->
                  
                  <!-- End content Item -->
                </div>
                <!-- Email -->
                <div class="col-md-4 email">
                  <!-- Icon -->
                  <div class="col-md-3 icon"> <i class="fa fa-envelope"></i> </div>
                  <!-- End Icon -->
                  <!-- Content Item -->
                  <div class="col-md-9 content-item">
                    <h3>E-MAIL</h3>
                    <p>support@trendsplacehotelandsuites.com
                    <a href="#"</a></p>
                  </div>
                  <!-- End content Item -->
                </div>
                <!--End Email -->
              </div>
            </div>
          </div>
        </div>
        <!-- End BG transparent -->
      </div>
      <!-- End BG parallax -->

    </section>
    <!-- End address content -->

  </div>
  <!-- end of #content -->
</div>

@endsection
