@extends('layouts.app')
@section("title", "My Account")
@section('content')

<div id="wrapper">

    <section class="yt-bg-player yt-account">
        <div class="bg-transparent ">
            <!-- Slider content -->
            <div class="container dark slider-content"> <i class="icon-top-draw"></i>
                <div id="text-transform" class="owl-carousel">
                    <div class="item">
                        <h1>{{ Auth::user()->first_name .' '. Auth::user()->last_name }}</h1>
                    </div>
                </div>
                <p class="text-capitalize">An Oasis Of Pleasure</p>
                <i class="icon-bottom-draw"></i>
            </div>
            <!-- End Slider content -->
        </div>
        <!-- End Bg transparent -->
    </section>
    @include('layouts.includes.main-header')

  <div id="content">
    @include('layouts.includes.main-nav')
    <!-- Carts
    ============================================= -->
    <section class="myaccount text-left" style="padding-bottom:20px;">
        <div class="container">
          <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-9 col-sm-8">
                        @if (Session::has('error'))
                            <div class="alert alert-danger">{{ Session::get('error') }}</div>
                        @endif
                        @if (Session::has('success'))
                            <div class="alert alert-success">{{ Session::get('success') }}</div>
                        @endif
                        <!-- Head Title -->
                        <h3 class="mt0 mb30"> <span>My</span> Account </h3>
                        <!-- End# Head Title -->
                        <!-- Head Title -->
                        <div class="majesty_tab">
                          <ul id="myTab2" class="nav nav-tabs" role="tablist">
                            <li role="presentation" class="active"><a href="#account" id="account-tab2" role="tab" data-toggle="tab" aria-controls="account" aria-expanded="true">Account</a></li>
                            <li role="presentation"><a href="#orders" role="tab" id="orders-tab2" data-toggle="tab" aria-controls="orders">Orders</a></li>
                            <li role="presentation"><a href="#password" role="tab" id="password-tab2" data-toggle="tab" aria-controls="password">Password</a></li>
                          </ul>
                          <div id="myTabContent" class="tab-content">
                            <div role="tabpanel" class="tab-pane fade in active" id="account" aria-labelledby="account-tab2">
                                    <!-- Account -->
                                    <div class="account col-md-8">
                                        <h3>Edit account</h3>
                                        <form class="form-horizontal" method="POST" action="{{ route("update.account") }}">
                                            @csrf
                                            <div class="form-group">
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control @error('first_name') border border-danger @enderror" name="first_name" id="first_name" placeholder="First Name*" value="{{ Auth()->user()->first_name }}">
                                                    @error('first_name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control @error('last_name') border border-danger @enderror" name="last_name" id="last_name" placeholder="Last Name*" value="{{ Auth()->user()->last_name }}">
                                                    @error('last_name')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control @error('tel') border border-danger @enderror" id="tel" name="tel" placeholder="Telephone*" value="{{ Auth()->user()->tel }}">
                                                    @error('tel')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-sm-10">
                                                    <input type="email" class="form-control @error('email') border border-danger @enderror" name="email" id="email" placeholder="Email*" value="{{ Auth()->user()->email }}" readonly>
                                                    @error('email')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-sm-10">
                                                    <input type="text" class="form-control" name="address" id="address" placeholder="Address*" value="{{ Auth()->user()->address }}" required>
                                                    @error('address')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                                </div>
                                            </div>
                                            <button type="submit" class="btn btn-black">Save Changes</button>
                                        </form>
                                    </div>
                                    <!-- End Account -->
                            </div>
                            <div role="tabpanel" class="tab-pane fade" id="orders" aria-labelledby="orders-tab2">
                                    <!-- Head Title -->
                                    <h3> <span>My</span> Orders </h3>
                                    <!-- End# Head Title -->
                                    <!-- Head Title -->
                                    <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#Order Id</th>
                                            <th>Product</th>
                                            <th>Quantity</th>
                                            <th>Price</th>
                                            <th>Subtotal</th>
                                            <th>Total</th>
                                            <th>Delivery Type</th>
                                            <th>Payment Status</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ( $orders as $order )
                                        @php
                                            $product = App\Models\Product::find($order->product_id);
                                        @endphp
                                            <tr>
                                                <th scope="row">{{ $order->order_id }}</th>
                                                <td>{{  $product->name }}</td>
                                                <td>{{ $order->quantity }}</td>
                                                <td>{{ $order->price }}</td>
                                                <td>{{ $order->subtotal }}</td>
                                                <td>{{ $order->total }}</td>
                                                <td>{{ $order->type }}</td>
                                                <td>{{ $order->payment_status }}</td>
                                                <td>{{ $order->created_at->diffForHumans() }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    </table>
                            </div>
                            <div role="tabpanel" class="tab-pane fade" id="password" aria-labelledby="password-tab2">
                                    <!-- Password -->
                                    <div class="password col-md-8">
                                        <h3>Password Change</h3>
                                        <form class="form-horizontal" method="POST" action="{{ route("change.password") }}">
                                            @csrf
                                        <div class="form-group">
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control @error('old_password') border border-danger @enderror" name="old_password" id="InputPassword" placeholder="Current Password">
                                                @error('old_password')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control @error('password') border border-danger @enderror" name="password" id="newInputPassword" placeholder="New Password">
                                                @error('password')<span class="ml-3 text-danger">{{ $message }}</span> @enderror
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-sm-10">
                                                <input type="password" class="form-control" name="password_confirmation" id="confirmInputPassword" placeholder="Confirm New Password">
                                            </div>
                                        </div>
                                        <button class="btn btn-black" type="submit">Save Changes</button>
                                        </form>
                                    </div>
                                    <!-- End Password -->
                              </div>
                          </div>
                        </div>

                      </div>
                      <!-- End Content -->
                  </div>
            </div>
          </div>
        </div>
      </section>
      <!-- End Carts -->
  </div>
  <!-- end of #content -->
</div>

@endsection
