@extends('layouts.app')
@section("title", "Trends Place")
@section('content')
<!-- End Loader -->
<!-- Document Wrapper
    ============================================= -->
    <div id="wrapper">

        <section id="slider" class="slider-parallax dark swiper_wrapper  clearfix">
            <div class="swiper-container swiper-parent">
              <!-- Slider Wrapper  -->
              <div class="swiper-wrapper">
                <!-- Slide  -->
                <div class="swiper-slide" style="background-image: url('{{ asset("img/banner/banner12.jpg") }}');">
                    <div class="slider-content">
                        <i class="icon-top-draw"></i>
                        <h1  data-caption-animate="fadeInUp">Trends Place </h1>

                        <i class="icon-bottom-draw"></i>
                      </div>
                </div>
                <!-- End Slide  -->
                <!-- Slide  -->
                <div class="swiper-slide" style="background-image: url('{{ asset("img/banner/banner22.jpg") }}');">
                    <div class="slider-content">
                        <i class="icon-top-draw"></i>
                         <h1  data-caption-animate="fadeInUp">Trends Place </h1>
                        <i class="icon-bottom-draw"></i>
                      </div>
                </div>
                <!-- End Slide  -->

                <!-- Slide  -->
                <div class="swiper-slide" style="background-image: url('{{ asset("img/banner/banner32.jpg") }}');">
                    <div class="slider-content">
                        <i class="icon-top-draw"></i>
                          <h1  data-caption-animate="fadeInUp">Trends Place </h1>
                        <i class="icon-bottom-draw"></i>
                        </div>
                </div>
                <!-- End Slide  -->

              </div>
              <!-- End Slider Wrapper  -->
              <div id="slider-arrow-left"><i class="fa fa-angle-left"></i></div>
              <div id="slider-arrow-right"><i class="fa fa-angle-right"></i></div>
            </div>
          </section>

        @include('layouts.includes.main-header')
        <!-- Document Content
          ============================================= -->
        <div id="content">
            <div class="container dis_search_mobile" style="display:none">
                <div class="row">
                    <div class="col-sm-12">
                        <form action="{{ route("search") }}" class="search_form_submit" method="GET">
                            <div id='input_group'>
                                <label id='label' for="input">
                                    <i class="fa fa-search js_submit_search" style="color:black;font-size:20px;"></i>
                                </label>
                                <input id='input' type="text" name="q" class="form-control" style="color:black" placeholder="Search food.">
                            </div>
                        </form>
                    </div>
            </div>
        </div>
          <!-- Masonry Menu
          ============================================= -->
          <section class="masonry_menu text-center ">
            <!-- Menu Bar -->
            @include('layouts.includes.main-nav')
            <!-- End menu bar -->
            <!-- Menu Items
                          ============================================= -->
            <div class="container">
              <!-- Menu Items Masonary Content -->
              <div id="menu-items" class="masonry-content dark clearfix" >
                @foreach ($products as $product)
                    <!-- Menu Item -->
                    <article class="menu-item pf-desert pf-daily-menu">
                        <!-- Overlay Content -->
                        <div class="overlay_content overlay-menu">
                        <!-- Overlay Item -->
                        <div class="overlay_item"> <img src="{{ asset("img/logo/logo_white.png") }}" alt="" style="width:360px; height:229px; object-fit:contain;">
                            <div class="overlay">
                            <div class="icons">
                                <h3>{{ $product->name }}</h3>
                                <h3>&#x20A6; {{ number_format($product->price, 2) }}</h3>
                                <!-- Button -->
                                <div class="button"> <a class="btn btn-gold addToCart" href="javascript:void(0)" data-id="{{ $product->id }}"><i class="fa fa-shopping-cart"></i></a> </div>
                                <!-- End Button -->
                                <a class="close-overlay hidden">x</a> </div>
                            </div>
                        </div>
                        <!-- Overlay Item -->
                        </div>
                        <!-- End Overlay Content -->
                    </article>
                    <!-- End Menu Item -->
                @endforeach

              </div>
              <!-- #menu end -->
            </div>
            <!-- end of container -->

            {{$products->links("pagination::bootstrap-4")}}
          </section>
          <!-- End masonry -->


    <!-- Menu Today
    ============================================= -->

    

    
      <!-- End our menu -->
        </div>

@endsection
