@php
    $product = App\Models\Product::find($order->product_id);
@endphp
<table class="table">
      <tr>
        <th scope="col">Order Id</th>
        <td>{{ $order->order_id }}</td>
      </tr>
      <tr>
        <th scope="col">Product Name</th>
        <td>{{ $product->name }}</td>
      </tr>
      <tr>
        <th scope="col">Full Name</th>
        <td>{{ $order->fullname }}</td>
      </tr>
      <tr>
        <th scope="col">Email</th>
        <td>{{ $order->email }}</td>
      </tr>
      <tr>
        <th scope="col">Phone</th>
        <td>{{ $order->phone }}</td>
      </tr>
      <tr>
        <th scope="col">Address</th>
        <td>{{ $order->address }}</td>
      </tr>
      <tr>
        <th scope="col">Quantity</th>
        <td>{{ $order->quantity }}</td>
      </tr>
      <tr>
        <th scope="col">Price</th>
        <td>&#8358; {{ number_format($order->price, 2) }}</td>
      </tr>
      <tr>
        <th scope="col">Subtotal</th>
        <td>&#8358; {{ number_format($order->subtotal, 2) }}</td>
      </tr>
      <tr>
        <th scope="col">Total</th>
        <td>&#8358; {{ number_format($order->total, 2) }}</td>
      </tr>
      <tr>
        <th scope="col">Type</th>
        <td>{{ $order->type }}</td>
      </tr>
      <tr>
        <th scope="col">Payment status</th>
        <td><span class="badge badge-success">{{ $order->payment_status }}</span></td>
      </tr>
      <tr>
        <th scope="col">Sale status</th>
        <td><span class="badge badge-warning">{{ $order->sale_status }}</span></td>
      </tr>
      <tr>
        <th scope="col">Date</th>
        <td>{{ $order->date }}</td>
      </tr>
      <tr>
        <th scope="col">Time</th>
        <td>{{ $order->time }}</td>
      </tr>
      <tr>
        <th scope="col">Instructions</th>
        <td>{{ $order->instructions }}</td>
      </tr>
  </table>
