@extends('layouts.app')
@section("title", "Search - ")
@section('content')

<div id="wrapper">

    <section class="yt-bg-player yt-cart" >
        <div class="bg-transparent ">
            <!-- Slider content -->
            <div class="container dark slider-content"> <i class="icon-top-draw"></i>
                <div id="text-transform" class="owl-carousel">
                <div class="item">
                    <h1>Search</h1>
                </div>
                </div>
                <p class="text-capitalize">An Oasis Of Pleasure</p>
                <i class="icon-bottom-draw"></i>
            </div>
            <!-- End Slider content -->
        </div>
        <!-- End Bg transparent -->
    </section>
    @include('layouts.includes.main-header')

  <div id="content">
    @include('layouts.includes.main-nav')
    <section class="text-center our-menu mt60 padding-b-70">

        <div class="clearfix"></div>
        <!-- Menu Items
           ============================================= -->
        <!-- Menu Container -->
        <div class="menu-container dark">
          <!-- Menu Type -->
          <div class="menu-type">
            <!-- End Menu Title -->
            <div class="container">
              <div class="row">
                @if(count($products) != 0)
                @foreach ($products as $row)

                <!-- Item -->
                <div class="col-md-4 col-sm-6 col-xs-12 item">
                    <!-- Overlay Content -->
                    <div class="overlay_content overlay-menu">
                      <!-- Overlay Item -->
                      <div class="overlay_item"> <img src="/storage/img/{{ $row->photo }}" alt="">
                        <!-- Overlay -->
                        <div class="overlay">
                          <!-- Icons -->
                          <div class="icons">
                            <h3>{{ $row->name }}</h3>
                            <h3> &#8358; {{ number_format($row->price,2) }} </h3>
                            <a class="close-overlay hidden">x</a> </div>
                          <!-- End Icons -->
                        </div>
                        <!-- End Overlay -->
                      </div>
                      <!-- End Overlay Item -->
                    </div>
                    <p style="color:black">
                        {{ $row->description }}
                    </p>
                    <button class="btn btn-primary addToCart" style="margin:4px;padding:15px;" data-id="{{ $row->id }}">Add to Cart</button>
                    <!-- End Overlay Content -->
                  </div>
                  <!-- End item -->
                @endforeach
                </div>
                    <div class="row">
                        <div class="col-md-3 mx-auto">
                            {{ $products->links() }}
                        </div>
                    </div>
                @else

                    <h2 style="color:black;">Oops, product not found</h2>
                    <img src="https://img.icons8.com/color/48/000000/empty-trash--v2.png" style="width:100px;height:100px;"/>
                    <br/>
                    <a class="btn btn-primary" href="/">Continue Shopping</a>
                @endif
            </div>
          </div>
        </div>
        <!-- End Menu container -->
      </section>
  </div>
  <!-- end of #content -->
</div>
@endsection
