<?php $__env->startSection("title", "Admin"); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page-Title -->
    <div class="row">
        <div class="col-sm-12">
            <div class="page-title-box">
                <div class="row">
                    <div class="col">
                        <h4 class="page-title">Dashboard</h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Landnkitchen</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                    </div><!--end col-->
                </div><!--end row-->
            </div><!--end page-title-box-->
        </div><!--end col-->
    </div><!--end row-->
    <!-- end page title end breadcrumb -->

    <div class="row">
        <div class="col-lg-12">
            <div class="row justify-content-center">
                <div class="col-md-6 col-lg-3">
                    <div class="card report-card">
                        <div class="card-body">
                            <div class="row d-flex justify-content-center">
                                <div class="col">
                                    <p class="text-dark mb-0 font-weight-semibold">Customers</p>
                                    <h3 class="m-0"><?php echo e($count_customer); ?></h3>
                                </div>
                                <div class="col-auto align-self-center">
                                    <div class="report-main-icon bg-light-alt">
                                        <i data-feather="users" class="align-self-center text-muted icon-sm"></i>
                                    </div>
                                </div>
                            </div>
                        </div><!--end card-body-->
                    </div><!--end card-->
                </div> <!--end col-->
                <div class="col-md-6 col-lg-3">
                    <div class="card report-card">
                        <div class="card-body">
                            <div class="row d-flex justify-content-center">
                                <div class="col">
                                    <p class="text-dark mb-0 font-weight-semibold">Food</p>
                                    <h3 class="m-0"><?php echo e($count_product); ?></h3>
                                </div>
                                <div class="col-auto align-self-center">
                                    <div class="report-main-icon bg-light-alt">
                                        <i data-feather="clock" class="align-self-center text-muted icon-sm"></i>
                                    </div>
                                </div>
                            </div>
                        </div><!--end card-body-->
                    </div><!--end card-->
                </div> <!--end col-->
                <div class="col-md-6 col-lg-3">
                    <div class="card report-card">
                        <div class="card-body">
                            <div class="row d-flex justify-content-center">
                                <div class="col">
                                    <p class="text-dark mb-0 font-weight-semibold">Menu</p>
                                    <h3 class="m-0"><?php echo e($count_menu); ?></h3>
                                </div>
                                <div class="col-auto align-self-center">
                                    <div class="report-main-icon bg-light-alt">
                                        <i data-feather="activity" class="align-self-center text-muted icon-sm"></i>
                                    </div>
                                </div>
                            </div>
                        </div><!--end card-body-->
                    </div><!--end card-->
                </div> <!--end col-->
                <div class="col-md-6 col-lg-3">
                    <div class="card report-card">
                        <div class="card-body">
                            <div class="row d-flex justify-content-center">
                                <div class="col">
                                    <p class="text-dark mb-0 font-weight-semibold">Sales</p>
                                    <h3 class="m-0"><?php echo e($count_sales); ?></h3>
                                </div>
                                <div class="col-auto align-self-center">
                                    <div class="report-main-icon bg-light-alt">
                                        <i data-feather="briefcase" class="align-self-center text-muted icon-sm"></i>
                                    </div>
                                </div>
                            </div>
                        </div><!--end card-body-->
                    </div><!--end card-->
                </div> <!--end col-->
            </div><!--end row-->
        </div><!--end col-->
    </div><!--end row-->

    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h4 class="card-title">Customers</h4>
                        </div><!--end col-->
                    </div>  <!--end row-->
                </div><!--end card-header-->
                <div class="card-body">
                    <div class="table-responsive browser_users">
                        <table class="table mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-top-0">#</th>
                                    <th class="border-top-0">Name</th>
                                    <th class="border-top-0">Email</th>
                                    <th class="border-top-0">Phone Number</th>
                                    <th class="border-top-0">Date</th>
                                </tr><!--end tr-->
                            </thead>
                            <tbody>
                                <?php $sn  = 1; ?>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($sn); ?></td>
                                    <td><?php echo e($customer->first_name . ' '. $customer->last_name); ?></td>
                                    <td><?php echo e($customer->email); ?></td>
                                    <td><?php echo e($customer->tel); ?></td>
                                    <td><?php echo e($customer->created_at->diffForHumans()); ?></td>
                                </tr><!--end tr-->
                                <?php $sn++; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table> <!--end table-->
                    </div><!--end /div-->
                </div><!--end card-body-->
            </div><!--end card-->
        </div> <!--end col-->

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h4 class="card-title">Orders</h4>
                        </div><!--end col-->
                    </div>  <!--end row-->
                </div><!--end card-header-->
                <div class="card-body">
                    <div class="table-responsive browser_users">
                        <table class="table mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-top-0">#</th>
                                    <th class="border-top-0">Order Id</th>
                                    <th class="border-top-0">Full Name</th>
                                    <th class="border-top-0">Email</th>
                                    <th class="border-top-0">Telephone</th>
                                    <th class="border-top-0">Total</th>
                                    <th class="border-top-0">Type</th>
                                    <th class="border-top-0">Payment status</th>
                                    <th class="border-top-0">Sale status</th>
                                    <th class="border-top-0">Date</th>

                                </tr><!--end tr-->
                            </thead>
                            <tbody>
                                <?php $sn  = 1; ?>
                                <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($sn); ?></td>
                                        <td><?php echo e($sale->order_id); ?></td>
                                        <td><?php echo e($sale->fullname); ?></td>
                                        <td><?php echo e($sale->email); ?></td>
                                        <td><?php echo e($sale->phone); ?></td>
                                        <td><?php echo e($sale->total); ?></td>
                                        <td><?php echo e($sale->type); ?></td>
                                        <td><span class="badge badge-success"><?php echo e($sale->payment_status); ?></span></td>
                                        <td><span class="badge badge-warning"><?php echo e($sale->sale_status); ?></span></td>
                                        <td><?php echo e($sale->created_at->diffForHumans()); ?></td>
                                    </tr><!--end tr-->
                                <?php $sn++; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table> <!--end table-->
                    </div><!--end /div-->
                </div><!--end card-body-->
            </div><!--end card-->
        </div> <!--end col-->


        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h4 class="card-title">Products</h4>
                        </div><!--end col-->
                    </div>  <!--end row-->
                </div><!--end card-header-->
                <div class="card-body">
                    <div class="table-responsive browser_users">
                        <table class="table mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-top-0">#</th>
                                    <th class="border-top-0">Name</th>
                                    <th class="border-top-0">Category</th>
                                    <th class="border-top-0">Price</th>
                                    <th class="border-top-0">VAT</th>
                                    <th class="border-top-0">Date</th>
                                </tr><!--end tr-->
                            </thead>
                            <tbody>
                                <?php $sn  = 1; ?>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $category = App\Models\Category::find($product->category_id);
                                ?>
                                    <tr>
                                        <td><?php echo e($sn); ?></td>
                                        <td><?php echo e($product->name); ?></td>
                                        <td><?php echo e($category->name); ?></td>
                                        <td>&#8358; <?php echo e(number_format($product->price, 2)); ?></td>
                                        <td>&#8358; <?php echo e(number_format($product->vat, 2)); ?></td>
                                        <td><?php echo e($product->created_at->diffForHumans()); ?></td>
                                    </tr><!--end tr-->
                                <?php $sn++; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table> <!--end table-->
                    </div><!--end /div-->
                </div><!--end card-body-->
            </div><!--end card-->
        </div> <!--end col-->


        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h4 class="card-title">Menus</h4>
                        </div><!--end col-->
                    </div>  <!--end row-->
                </div><!--end card-header-->
                <div class="card-body">
                    <div class="table-responsive browser_users">
                        <table class="table mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th class="border-top-0">#</th>
                                    <th class="border-top-0">Name</th>
                                    <th class="border-top-0">Takeaway</th>
                                    <th class="border-top-0">Date</th>

                                </tr><!--end tr-->
                            </thead>
                            <tbody>
                                <?php $sn  = 1; ?>
                                <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($sn); ?></td>
                                        <td><?php echo e($menu->name); ?></td>
                                        <td><?php if($menu->takeaway == 1): ?>
                                            Yes
                                        <?php else: ?>
                                            No
                                        <?php endif; ?>
                                        </td>
                                        <td><?php echo e($menu->created_at->diffForHumans()); ?></td>
                                    </tr><!--end tr-->
                                <?php $sn++; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table> <!--end table-->
                    </div><!--end /div-->
                </div><!--end card-body-->
            </div><!--end card-->
        </div> <!--end col-->
    </div><!--end row-->

</div><!-- container -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/landnkitchen/public_html/core/resources/views/admin/index.blade.php ENDPATH**/ ?>